***---Import NAMP DATA from Excel into SAS---***;

Options nocenter nodate ls=120 ps=45;
PROC IMPORT OUT=WORK.sites 
            DATAFILE= "D:\Masters Thesis\Data\All_NAMP_Combined.xls" 
            DBMS=EXCEL REPLACE;
     SHEET="'Sites_DC$'"; 
     GETNAMES=YES;
     MIXED=NO;
     SCANTEXT=YES;
     USEDATE=YES;
     SCANTIME=YES;
RUN;

data NAMP;
set sites;
if plot_cluster='.' then delete;
rename plot_cluster=site;
run;

***---Coding of Site Variables for Regressions---***;

data all;
set NAMP;
if name='no site data' then delete;
if dieback = '.' then delete;
if terrain='hilly' then terrain1=2;
if terrain='flat' then terrain1=1;
if terrain='mountainous' then terrain1=3;
if landform='ridgetop' then landform1=1;
if landform='spur ridge' then landform1=2;
if landform='noseslope' then landform1=3;
if landform='headslope' then landform1=4;
if landform='sideslope' then landform1=5;
if landform='cove' then landform1=6;
if landform='draw' then landform1=7;
if landform='flat' then landform1=8;
if slope_pos='summit' then slope_pos1=1;
if slope_pos='floodplain' then slope_pos1=5;
if slope_pos='flat' then slope_pos1=5;
if slope_pos='backslope' then slope_pos1=2;
if slope_pos='shoulder' then slope_pos1=1;
if slope_pos='footslope' then slope_pos1=3;
if slope_pos='terrace' then slope_pos1=4;
if microrelief='planar' then microrelief1=2;
if microrelief='concave' then microrelief1=3;
if microrelief='convex' then microrelief1=1;
if soil_tex='silt/clay' then soil_tex1=7;
if soil_tex='fine sand' then soil_tex1=6;
if soil_tex='medium sand' then soil_tex1=5;
if soil_tex= 'coarse sand' then soil_tex1=4;
if soil_tex= 'fine gravel' then soil_tex1=3;
if soil_tex= 'coarse gravel' then soil_tex1=2;
if soil_tex= 'rocks' then soil_tex1=1;
if soil_drain='well drained' then soil_drain1=1;
if soil_drain='poorly drained' then soil_drain1=2;
if site_rock='none' then site_rock1=1;
if site_rock='2-10 in plot' then site_rock1=2;
if site_rock='>10 in plot' then site_rock1=3;
if crown_close='full' then crown_close1=3;
if crown_close='moderate' then crown_close1=2;
if crown_close='open' then crown_close1=1;
if crown_struc='single story' then crown_struc1=1;
if crown_struc='two story' then crown_struc1=2;
if crown_struc='multi-story' then crown_struc1=3;
if site_qual='average' then site_qual1=2;
if site_qual='poorer' then site_qual1=3;
if site_qual='better' then site_qual1=1;
if site_qual='Better' then site_qual1=1;
run;

data landformnumericdata;
set all;
if landform='ridgetop' then position1=1;
if landform='spur ridge' then position1=1;
if landform='noseslope' then position1=1;
if landform='headslope' then position1=1;
if landform='Sideslope' then position1=2;
if landform='sideslope' then position1=2;
if landform='cove' then position1=3;
if landform='draw' then position1=3;
if landform='flat' then position1=3;
if slope_pos='summit' then position1=1;
if slope_pos='floodplain' then position1=3;
if slope_pos='flat' then position1=3;
if slope_pos='backslope' then position1=1;
if slope_pos='shoulder' then position1=1;
if slope_pos='footslope' then position1=2;
if slope_pos='terrace' then position1=2;
if aspect>0 and aspect<45 then aspect1=1;
if aspect>45 and aspect<135 then aspect1=2;
if aspect>135 and aspect<225 then aspect1=3;
if aspect>225 and aspect<315 then aspect1=2;
if aspect>=315 and aspect<=360 then aspect1=1;
if aspect=0 then aspect1=1;
position1squared=position1**2;
microrelief1squared=microrelief1**2;
fiveyearmeanzsquared=fiveyearmeanz**2;
percsmsquared=percsm**2;
run;
***Regression Codes***;
Data regcodes;
set landformnumericdata;
if pH_B='.' then delete;
run;
***---Variable Correlations---***;
proc corr data=landformnumericdata;
var BA_mha RD_sqftperac DBH SM_BA_mha site_qual1 crown_close1 crown_struc1 elevation site_rock1 terrain1 landform1 slope_pos1 position1 slope_perc aspect1 microrelief1 soil_tex1 soil_drain1 Depth_to_RR Depth_A Depth_B A_Al A_Ca A_Mg A_K A_Ca_Al B_Ca_Al B_Al B_Ca B_K B_Mg pH_A pH_B DI fiveyearmeantemp fiveyearmeanprecip fiveyearmeanz annualmintemp annualmaxtemp annualmeantemp summermeanprecip Defol_2002 Defol_2004 Defol_2005 Defol_2006 Defol_2007 DSI total_defol defol PERCSM annualmeanprecip management;
with PERCSMMORT;
run;
proc corr data=landformnumericdata;
var BA_mha RD_sqftperac DBH SM_BA_mha site_qual1 crown_close1 crown_struc1 elevation site_rock1 terrain1 landform1 slope_pos1 position1 slope_perc aspect1 microrelief1 soil_tex1 soil_drain1 Depth_to_RR Depth_A Depth_B A_Al A_Ca A_Mg A_K A_Ca_Al B_Ca_Al B_Al B_Ca B_K B_Mg pH_A pH_B DI fiveyearmeantemp fiveyearmeanprecip fiveyearmeanz annualmintemp annualmaxtemp annualmeantemp summermeanprecip Defol_2002 Defol_2004 Defol_2005 Defol_2006 Defol_2007 DSI total_defol defol PERCSM annualmeanprecip management;
with Dieback_08;
run;

***Multicollinearity***;
PROC REG DATA=landformnumericdata;
  MODEL PERCSMMORT = B_Ca B_Mg B_K / VIF COLLIN;
  model PERCSMMORT = annualmintemp annualmeantemp / vif collin;
  model PERCSMMORT = BA_mha crown_struc1 / vif collin;
  run;

PROC REG DATA=landformnumericdata;
  MODEL Dieback_08 = BA_mha SM_BA_mha / vif collin;
  model Dieback_08 = A_Ca A_Mg A_K B_Ca B_Mg B_K / vif collin;
  model Dieback_08 = annualmintemp annualmaxtemp annualmeantemp fiveyearmeantemp / vif collin;
  model Dieback_08 = annualmintemp annualmaxtemp / vif collin;
  model Dieback_08 = annualmintemp annualmeantemp / vif collin; 
  Model Dieback_08 = annualmeantemp annualmaxtemp / vif collin;
  model Dieback_08 = defol Defol_2006 / vif collin;
  model Dieback_08 = A_Ca B_Mg / vif collin;
  model Dieback_08 = A_Ca B_Ca / vif collin;
  run;


*===Multiple Linear Regression Procedure using AIC Rsq and RMSE as selection criteria===*;
***MORTALITY MODELS***;

PROC REG DATA=regcodes;
  MODEL PERCSMMORT = microrelief1 crown_struc1 B_Ca fiveyearmeanz annualmintemp Defol_2005 / selection=rsquare adjrsq aic cp bic press dw rmse vif;

PROC REG DATA=regcodes;
  MODEL PERCSMMORT = microrelief1 crown_struc1 B_Mg fiveyearmeanz annualmintemp Defol_2005 / selection=rsquare adjrsq aic cp bic press dw rmse vif;
PROC REG DATA=regcodes;
  MODEL PERCSMMORT = microrelief1 B_K fiveyearmeanz annualmintemp Defol_2005 / selection=rsquare adjrsq aic cp bic press dw rmse vif spec;
output out=out p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out;
var PERCSMMORT predict residual student;
run;
proc univariate data=out plot normal;
var residual;
run;
PROC REG DATA=regcodes;
MODEL PERCSMMORT = microrelief1 crown_struc1 B_K fiveyearmeanz annualmintemp Defol_2005 / selection=rsquare adjrsq aic cp bic press dw rmse vif spec;
output out=out1 p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out1;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out1;
var PERCSMMORT predict residual student;
run;
proc univariate data=out1 plot normal;
var residual;
run;
PROC REG DATA=regcodes;
MODEL PERCSMMORT = crown_struc1 microrelief1 B_K fiveyearmeanz annualmintemp Defol_2005 / selection=rsquare adjrsq aic cp bic press dw rmse vif spec;
output out=out2 p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out2;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out2;
var PERCSMMORT predict residual student;
run;
proc univariate data=out2 plot normal;
var residual;
run;
PROC REG DATA=regcodes;
MODEL PERCSMMORT = microrelief1 B_Ca B_K fiveyearmeanz annualmintemp Defol_2005 / selection=rsquare adjrsq aic cp bic press dw rmse vif spec;
output out=out3 p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out2;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out3;
var PERCSMMORT predict residual student;
run;
proc univariate data=out3 plot normal;
var residual;
run;
PROC REG DATA=regcodes;
MODEL PERCSMMORT = microrelief1 B_Mg B_K fiveyearmeanz annualmintemp Defol_2005 / selection=rsquare adjrsq aic cp bic press dw rmse vif spec;
output out=out4 p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out4;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out4;
var PERCSMMORT predict residual student;
run;
proc univariate data=out4 plot normal;
var residual;
run;
PROC REG DATA=regcodes;
MODEL PERCSMMORT = microrelief1 B_Mg fiveyearmeanz annualmintemp Defol_2005 / selection=rsquare adjrsq aic cp bic press dw rmse vif spec;
output out=out5 p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out5;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out5;
var PERCSMMORT predict residual student;
run;
proc univariate data=out5 plot normal;
var residual;
run;


***----DIEBACK MODELS---***;

PROC REG DATA=regcodes;
  MODEL Dieback_08 = Defol_2006 microrelief1 fiveyearmeantemp fiveyearmeanz A_Mg / selection=rsquare adjrsq aic cp dw press bic rmse vif spec;

output out=out6 p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out6;
var PERCSMMORT predict residual student;
run;
proc univariate data=out6 plot normal;
var residual;
run;

PROC REG DATA=regcodes;
  MODEL Dieback_08 = Defol_2006 microrelief1 fiveyearmeantemp fiveyearmeanz A_K / selection=rsquare adjrsq aic cp dw press bic rmse vif spec;
output out=out7 p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out7;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out7;
var PERCSMMORT predict residual student;
run;
proc univariate data=out7 plot normal;
var residual;
run;

PROC REG DATA=regcodes;
  MODEL Dieback_08 = Defol_2006 microrelief1 fiveyearmeantemp fiveyearmeanz A_K BA_mha/ selection=rsquare adjrsq aic cp dw press bic rmse vif spec;
output out=out8 p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out8;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out8;
var PERCSMMORT predict residual student;
run;
proc univariate data=out8 plot normal;
var residual;
run;

PROC REG DATA=regcodes;
  MODEL Dieback_08 = Defol_2006 microrelief1 fiveyearmeantemp fiveyearmeanz A_Mg BA_mha / selection=rsquare adjrsq aic cp dw press bic rmse vif spec;
output out=out8 p=predict r=residual student=student;
  ***residual analysis***;
proc plot data=out9;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out9;
var PERCSMMORT predict residual student;
run;
proc univariate data=out9 plot normal;
var residual;
run;


PROC REG DATA=regcodes;
  MODEL Dieback_08 = Defol_2006 microrelief1 annualmeantemp fiveyearmeanz A_Mg/ selection=rsquare adjrsq aic cp dw press bic rmse vif spec;
output out=out10 p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out10;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out10;
var PERCSMMORT predict residual student;
run;
proc univariate data=out10 plot normal;
var residual;
run;

PROC REG DATA=regcodes;
  MODEL Dieback_08 = Defol_2006 microrelief1 fiveyearmeantemp fiveyearmeanz A_Mg A_K BA_mha / selection=rsquare adjrsq aic cp dw press bic rmse vif spec;
output out=out11 p=predict r=residual student=student;
run;
***residual analysis***;
proc plot data=out11;
plot residual*predict='*' / vref=0;
plot student*predict='*' / vref=0;
proc print data=out11;
var PERCSMMORT predict residual student;
run;
proc univariate data=out11 plot normal;
var residual;
run;
