*****************************************
Calculate nutrient uptake at Calhoun based on data collected in July, 2001.
units: con (mg/L), delt (ug), uptake (ug/groot/hr)
*****************************************;
OPTIONS LS=78 PS=78 NOCENTER;

DATA CALHOUN;
INFILE 'cal04021a.txt' firstobs=2;
INPUT site $ ExpNumb sampleid TimeIn DateFi $ TimeFin $ TimeEl species $ nscon NH4init NH4Fin NO3init NO3Fin PO4init PO4Fin CAinit CAFin MGinit MGFin NAinit NAFin Kinit KFin ALinit ALFin;
volume1 = 30;
volume2 = 30;


*Compute change in % concentration of nutrients;
   NH4delt = 100*(NH4init*volume1 - NH4Fin*volume2)/(NH4init*volume1);
   NO3delt = 100*(NO3init*volume1 - NO3Fin*volume2)/(NO3init*volume1);
   PO4delt = 100*(PO4init*volume1 - PO4Fin*volume2)/(PO4init*volume1);
   CAdelt = 100*(CAinit*volume1 - CAFin*volume2)/(CAinit*volume1);
   MGdelt = 100*(MGinit*volume1 - MGFin*volume2)/(MGinit*volume1);
   NAdelt = 100*(NAinit*volume1 - NAFin*volume2)/(NAinit*volume1);
   Kdelt = 100*(Kinit*volume1 - KFin*volume2)/(Kinit*volume1);
   ALdelt = 100*(ALinit*volume1 - ALFin*volume2)/(ALinit*volume1);
/*

*Compute change in concentration of nutrients;
   NH4delt = NH4init*volume1 - NH4Fin*volume2;
   NO3delt = NO3init*volume1 - NO3Fin*volume2;
   PO4delt = PO4init*volume1 - PO4Fin*volume2;
   CAdelt = CAinit*volume1 - CAFin*volume2;
   MGdelt = MGinit*volume1 - MGFin*volume2;
   NAdelt = NAinit*volume1 - NAFin*volume2;
   Kdelt = Kinit*volume1 - KFin*volume2;
   ALdelt = ALinit*volume1 - ALFin*volume2;
*/
Data roots;
   infile 'rootwts.txt';
   input sampleid rootwt;

data allsites;
   set calhoun;

proc sort data=roots;
   by sampleid;
proc sort data=allsites;
   by sampleid;

data uptake;
   merge allsites roots; by sampleid;
   NH4rate = NH4delt/TimeEl/rootwt;
   NO3rate = NO3delt/TimeEl/rootwt;
   PO4rate = PO4delt/TimeEl/rootwt;
   CArate = CAdelt/TimeEl/rootwt;
   NArate = NAdelt/TimeEl/rootwt;
   Krate = Kdelt/TimeEl/rootwt;
   MGrate = MGdelt/TimeEl/rootwt;
   ALrate = ALdelt/TimeEl/rootwt;
   if species = ' ' then delete;
   if sampleid < 400 then delete;
   if rootwt = '.' then delete;


proc sort data=uptake; by site species nscon sampleid;

proc print;
   var sampleid TimeEl NH4rate PO4rate CArate Krate MGrate NArate ALrate;
   by site species nscon;

   proc means mean n stderr;
   var NH4rate PO4rate CArate Krate MGrate NArate ALrate;
   by site species nscon;
   output out=stats1 mean= mNH4rate mPO4rate mCArate mKrate mMGrate mNArate mALrate n= nNH4rate nPO4rate nCArate nKrate nMGrate nNArate nALrate stderr= eNH4rate ePO4rate eCArate eKrate eMGrate eNArate eALrate;

proc sort data=uptake; by site species nscon TimeEl sampleid;

proc means mean n stderr;
   var NH4rate PO4rate CArate Krate MGrate NArate ALrate;
   by site species nscon TimeEl;
   output out=stats2 mean= mNH4rate mPO4rate mCArate mKrate mMGrate mNArate mALrate n= nNH4rate nPO4rate nCArate nKrate nMGrate nNArate nALrate stderr= eNH4rate ePO4rate eCArate eKrate eMGrate eNArate eALrate;

proc plot hpercent=50 vpercent=34 data=uptake;
   plot PO4rate * PO4init;
   plot CArate * CAinit;
   plot Krate * Kinit;
   plot MGrate * MGinit;
   plot NArate * NAinit;
   plot ALrate * ALinit;
   by site species;

DATA calout1;
SET stats1;
FILE 'calout1.out' LRECL=600;
PUT site $ species $ nscon mNH4rate mPO4rate mCArate mKrate mMGrate mNArate mALrate eNH4rate ePO4rate eCArate eKrate eMGrate eNArate eALrate nNH4rate nPO4rate nCArate nKrate nMGrate nNArate nALrate;
 
DATA calout2;
SET stats2;
FILE 'calout2.out' LRECL=600;
PUT site $ species $ nscon TimeEl mNH4rate mPO4rate mCArate mKrate mMGrate mNArate mALrate eNH4rate ePO4rate eCArate eKrate eMGrate eNArate eALrate nNH4rate nPO4rate nCArate nKrate nMGrate nNArate nALrate;

