*****************************************Calculate nutrient uptake at Colorado sites.
units: con (mg/L), cont and Delt1 (umol), uptake (umol/groot/hr)***************************************************
This program was written by Karis many years ago.6-7/2008 Dusty Wood adapted it. 
Ruth made comments and some changes.
I removed Delta, which was the percentage change.
I removed the initial concentrations and volumes, because they cancel out when 
we subtract the controls (there were errors in the inits, anyway).
I replaced "Delt" with calculations of concentration.
I fixed the error in units (volumes are in ml, not L).
Note that the file has dates and times but time format was problematic.**********
Content is calculated using the measured final volumes.
Content1 is calculated without final volumes, using initial volumes.
Controls are currently averaged by site and nscon-we could also do it by experiment (with TEl).*****;
****************************************************************;

OPTIONS LS=100 PS=100 NOCENTER NODATE PAGENO=1;
PROC IMPORT OUT= WORK.roots 
            DATAFILE= "H:\roots\NewRootUptake.xls" 
            DBMS=EXCEL REPLACE;
     SHEET="Input$"; 
     GETNAMES=YES;
     MIXED=YES;
     SCANTEXT=YES;
     USEDATE=YES;
     SCANTIME=YES;
RUN;
Data rootdata;   
SET roots;
* Convert concentrations from mg to umols-"Conumols"*************;
NH4Conumols = NH4Con*1000/14.0067;
NO3Conumols = NO3Con*1000/14.0067;
PO4Conumols = PO4Con*1000/30.973761;
CaConumols = CaCon*1000/40.078;
MgConumols = MgCon*1000/24.305;
NaConumols = NaCon*1000/22.98977;
KConumols = KCon*1000/39.0983;
AlConumols = AlCon*1000/26.981538;* 
Calculate final content (concentration*volume) *******************;   
NH4content = NH4Conumols*FinVol/1000;   
NO3content = NO3Conumols* FinVol/1000;  
PO4content = PO4Conumols* FinVol/1000;  
CAcontent = CAConumols* FinVol/1000;   
MGcontent = MGConumols* FinVol/1000;   
NAcontent = NAConumols* FinVol/1000;   
Kcontent = KConumols* FinVol/1000;   
ALcontent = ALConumols* FinVol/1000;
run;

***HERE IS WHERE I HAVE STARTED A PROGRAM TO AVERAGE THE CONTROLS BY 1) SITE AND NSCON, AND 2) SITE, NSCON, AND TEL***;

Data meancontrols;
set rootdata;
If Site = 'LOCHV' then do;
NH4content1 = NH4Conumols*30/1000;
NO3content1 = NO3Conumols*30/1000;
PO4content1 = PO4Conumols*30/1000;
CAcontent1 = CAConumols*30/1000;
MGcontent1 = MGConumols*30/1000;
NAcontent1 = NAConumols*30/1000;
Kcontent1 = KConumols*30/1000;
ALcontent1 = ALConumols*30/1000;
End;
if Site = 'FRASER' then do;
NH4content1 = NH4Conumols*27/1000;
NO3content1 = NO3Conumols*27/1000;
PO4content1 = PO4Conumols*27/1000;
CAcontent1 = CAConumols*27/1000;
MGcontent1 = MGConumols*27/1000;
NAcontent1 = NAConumols*27/1000;
Kcontent1 = KConumols*27/1000;
ALcontent1 = ALConumols*27/1000;
end;
run;
data controls;
set meancontrols;
if spec = 'CL' then output;
run;
**********************************************
calculating means*******************************
*********************
**Site, nscon****;
proc sort data=controls; by Site nscon;
proc means mean noprint;
var NH4content1 NO3content1 PO4content1 CAcontent1 MGcontent1 NAcontent1 Kcontent1 ALcontent1;
by Site nscon;
output out=sitenscon mean=NH4control NO3control PO4control CAcontrol MGcontrol NAcontrol Kcontrol ALcontrol;
run;
***merge the means to the observations and determine uptake****;
proc sort data=meancontrols;
by Site nscon;
run;
data controlmerge;
merge sitenscon meancontrols;
by Site nscon;
***NH4control is already in the excel input file*****;
NH4uptake = NH4control - NH4content1;
NO3uptake = NO3control - NO3content1;
PO4uptake = PO4control - PO4content1;
CAuptake = CAcontrol - CAcontent1;
NAuptake = NAcontrol - NAcontent1;
Kuptake = Kcontrol - Kcontent1;
MGuptake = MGcontrol - MGcontent1;
ALuptake = ALcontrol - ALcontent1;
run;

*****means by Site, nscon, TEL******************************************;

proc sort data=controls;
by Site nscon TEl;
run;
proc means mean noprint;
var NH4content1 NO3content1 PO4content1 CAcontent1 MGcontent1 NAcontent1 Kcontent1 ALcontent1;
by Site nscon TEl;
output out=sitenscontel mean=NH4control NO3control PO4control CAcontrol MGcontrol NAcontrol Kcontrol ALcontrol;
run;
**merge the means****
*Site, nscon, TEL****;
proc sort data=meancontrols;
by Site nscon TEl;
run;
***uptake1 is the same thing as uptake, calculated the same way, but since there are two 
different means of interpreting it (Site-nscon and Site-nscon-Tel), there needed to be two
different variable names, hence 'uptake'(site-nscon) and 'uptake1' (site-nscon-tel)******
*************************************************************************************;
data controlmerge1;
merge sitenscontel meancontrols;
by Site nscon TEl;
NH4uptake1 = NH4control - NH4content1;
NO3uptake1 = NO3control - NO3content1;
PO4uptake1 = PO4control - PO4content1;
CAuptake1 = CAcontrol - CAcontent1;
NAuptake1 = NAcontrol - NAcontent1;
Kuptake1 = Kcontrol - Kcontent1;
MGuptake1 = MGcontrol - MGcontent1;
ALuptake1 = ALcontrol - ALcontent1;
run;


**************************
*Merge and input root weights;
Data roots1;   
infile 'H:\roots\coloroots.txt' 
firstobs=2;   
input Sampleid freshwt SA length drywt;

proc sort data=roots1;   
by Sampleid;
run;
proc sort data=controlmerge;   
by Sampleid;
run;

***fresh weight uptake rates ----IF you want controls by Site NSCON and TEL, then change "controlmerge" to 
"controlmerge1" and the elements, for example, "NH4uptake" to "NH4uptake1", and so forth*****;

data uptakerate;
merge controlmerge roots1; 
by Sampleid;
IF spec = 'Fir' or  spec = 'Spru' then do;   
NH4rate = NH4uptake/TEl/freshwt;   
NO3rate = NO3uptake/TEl/freshwt;  
PO4rate = PO4uptake/TEl/freshwt;   
CArate = CAuptake/TEl/freshwt;   
NArate = NAuptake/TEl/freshwt;   
Krate = Kuptake/TEl/freshwt;   
MGrate = MGuptake/TEl/freshwt;  
ALrate = ALuptake/TEl/freshwt;
END;
Title 'uptake by site and nscon';
run;

************************************;
***export the data to the excel file****************
**********************************************************************************
**********************************************************************************;
**change the outfile path if necessary****;
proc export data=uptakerate replace outfile = 'H:\roots\NewRootUptake.xls';
run;

*************************************************************************************
****Karis's program-PROC MIXED REPEATED MEASURES ANALYSIS **************************
**************************************************************************************
*********************************************************;

Data allrootuptake;  
set uptakerate;  
***remove controls*****;
if spec = 'CL' then delete;
***convert the nscons to class variables****;
if nscon=1 then nscon1='One'; 
if nscon=5 then nscon1='Five';  
if nscon=10 then nscon1='Ten';
run;
***((Ca))*****;
title 'Ca uptake Rpt Meas';
PROC MIXED data=allrootuptake;
CLASS Site spec nscon1 TEl;
model CArate = Site spec Site*spec nscon1 Site*nscon1 TEl nscon1*TEl Site*spec*nscon1/ ddfm=kr outpm=pred S;
repeated TEl/SUBJECT=SampleID type=CS r rcorr;
**means comparison for Site*nscon1***;
LSMEANS Site*nscon1/slice= Site;
LSMEANS Site*nscon1/slice= nscon1;
lsmeans Site*nscon1/adjust= tukey;
run;

***(((NH4)))*****;
TITLE "NH4 uptake rate Rpt Meas";
PROC MIXED data=allrootuptake;
CLASS Site spec nscon1 TEl;
model NH4rate = Site spec Site*spec nscon1 Site*nscon1 TEl nscon1*TEl Site*spec*nscon1/ ddfm=kr outpm=pred S;
repeated TEl/SUBJECT=SampleID type=CS r rcorr;
****means comparison for nscon1*TEl
LSMEANS nscon1*TEl/slice=nscon1
LSMEANS nscon1*TEl/slice=TEl
lsmeans nscon1*TEl/adjust=tukey***
run;

***((Mg))*****;
title 'Mg uptake rate Rpt Meas';
PROC MIXED data=allrootuptake;
CLASS Site spec nscon1 TEl;
model MGrate = Site spec Site*spec nscon1 Site*nscon1 TEl nscon1*TEl Site*spec*nscon1/ ddfm=kr outpm=pred S;
repeated TEl/SUBJECT=SampleID type=CS r rcorr;
**means comparison for Site*nscon**;
LSMEANS Site*nscon1/slice=Site;
LSMEANS Site*nscon1/slice=nscon1;
lsmeans Site*nscon1/adjust=tukey;
**means comparison for nscon1*TEl, if important***
LSMEANS nscon1*TEl/slice=nscon1
LSMEANS	nscon1*TEl/slice=TEl
lsmeans nscon1*TEl/adjust=tukey****;
run;

***((K))*****;
title 'K uptake rate Rpt Meas';
PROC MIXED data=allrootuptake;
CLASS Site spec nscon1 TEl;
model Krate = Site spec Site*spec nscon1 Site*nscon1 TEl nscon1*TEl Site*spec*nscon1/ ddfm=kr outpm=pred S;
repeated TEl/SUBJECT=SampleID type=CS r rcorr;
**no significant interactions-thus, no slices or means testing**;
run;

***((NO3))*****;
title 'NO3 Concentration Uptake Rpt Meas';
PROC MIXED data=allrootuptake;
CLASS Site spec nscon1 TEl;
model NO3rate = Site spec Site*spec nscon1 Site*nscon1 TEl nscon1*TEl Site*spec*nscon1/ ddfm=kr outpm=pred S;
repeated TEl/SUBJECT=SampleID type=CS r rcorr;
**no significant interactions-thus, no slices or means testing****;
run;


**Y can be concentration, % remaining, or uptake rates for each nutrientTimeEl 
I'm not sure if it needs to be here or not. 
I think it will run without - if so it can be taken out.type=CS 
type=___ specifies the covariance structure for the repeated measures. 
Some structures won't run with some data sets. Try "CS" first. 
If it doesn't run (SAS crashes), try "UN", "UN(1)", "UN(2)", or "UN(3)"';

******************************************************************************
************************************************
***THIS IS THE END OF THE REPEATED MEASURES ANALYSIS. THE FOLLOWING PROCEDURES
ARE FOR DESCRIPTIVE STATISTICS AND GLM, SO IGNORE THE REST OF THIS SAS CODE*******
*************************************************************************
***************************************************************************
****************************************************************************


********************* STATISTICAL ANALYSES*******************************
***************************************************************************************;
**by site and nscon**************;
data glm;
set uptakerate;
if spec= 'CL' then delete;
run;
proc sort data=glm;
by spec;
run;
**fresh weight***;
title 'freshwt glm by species between sites';
proc glm data=glm;
by spec;
class Site;
model freshwt= Site;
means Site/lsd;
run;
**root length***;
title 'length glm by species between sites';
proc glm data=glm;
by spec;
class Site;
model length= Site;
means Site/lsd;
run;
*****;
data glm;
set uptakerate;
if TEl ne 2 then delete;
if spec= 'CL' then delete;
run;
proc glm data=glm;
class site spec;
model NH4rate= site|spec;
title 'NH4rate glm';
run;
proc glm data=glm;
class site spec;
model NO3rate= site|spec;
title 'NO3rate glm';
run;
proc glm data=glm;
class site spec;
model CArate= site|spec;
title 'CArate glm';
run;
proc glm data=glm;
class site spec;
model MGrate= site|spec;
title 'MGrate glm';
run;
proc glm data=glm;
class site spec;
model Krate= site|spec;
title 'Krate glm';
run;


****Testing to see whether controls differ with TEl by site and nscon******
**************************;

****glm for uptake on controls******************************************************************;
data glmuptake;
set uptakerate;
if spec ne 'CL' then delete;
run;
proc sort data=glmuptake;
by nscon;
run;
***(((NH4)))****;
proc glm data=glmuptake;
by nscon;
model NH4Con= TEl;run;
***(((Ca)))****;
proc glm data=glmuptake;
by nscon;
model CaCon= TEl;run;
***(((Mg)))****;
proc glm data=glmuptake;
by nscon;
model MgCon= TEl;
run;
***(((PO4)))****;
proc glm data=glmuptake;
by nscon;
model PO4Con= TEl;
run;
***(((K)))****;
proc glm data=glmuptake;
by nscon;
model KCon= TEl;
run;
***(((NO3)))****;
proc glm data=glmuptake;
by nscon;
model NO3Con= TEl;
run;
proc sort data=glmuptake;
by Site;
run;
**(((NH4)))***;
proc glm data=glmuptake;
by Site;
model NH4Con= TEl;
run;
***(((Ca)))****;
proc glm data=glmuptake;
by Site;
model CaCon= TEl;
run;
***(((Mg)))***;
proc glm data=glmuptake;
by Site;
model MgCon= TEl;
run;
***(((PO4)))***;
proc glm data=glmuptake;
by Site;
model PO4Con= TEl;
run;
***(((K)))***;
proc glm data=glmuptake;
by Site;
model KCon= TEl;
run;
***(((NO3)))****;
proc glm data=glmuptake;
by Site;
model NO3Con= TEl;
run;
***PROC GLMs for Delt1s, by element solution***********************************;
*(((NH4)))****;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model NH4delt1= spec nscon Site TEl spec*nscon spec*Site 
spec*TEl nscon*Site nscon*TEL Site*TEl;
title 'NH4 delt1';
run;
**(((Ca)))****;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model CAdelt1= spec nscon Site TEl spec*nscon spec*Site s
pec*TEl nscon*Site nscon*TEL Site*TEl;
title 'Ca delt 1';
run;
**(((PO4)))***;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model PO4delt1= spec nscon Site TEl spec*nscon spec*Site 
spec*TEl nscon*Site nscon*TEL Site*TEl;
title 'PO4 delt 1';
run;
***(((NO3)))***;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model NO3delt1= spec nscon Site TEl spec*nscon spec*Site spec*TEl 
nscon*Site nscon*TEL Site*TEl;
title 'NO3delt1';
run;
***(((Mg)))***;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model MGdelt1= spec nscon Site TEl spec*nscon spec*Site spec*TEl 
nscon*Site nscon*TEL Site*TEl;
title 'MGdelt1';
run;
***(((K)))****;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model Kdelt1= spec nscon Site TEl spec*nscon spec*Site spec*TEl 
nscon*Site nscon*TEL Site*TEl;
title 'Kdelt1';
run;
****PROC GLM's for uptake rates, by element solution*************************************************;
**(((NH4)))****;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model NH4rate= spec nscon Site TEl spec*nscon spec*Site 
spec*TEl nscon*Site nscon*TEL Site*TEl;
title 'NH4 rate';
run;
**(((Ca)))****;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model CArate= spec nscon Site TEl spec*nscon spec*Site 
spec*TEl nscon*Site nscon*TEL Site*TEl;
title 'CA rate';
run;**(((PO4)))***;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model PO4rate= spec nscon Site TEl spec*nscon 
spec*Site spec*TEl nscon*Site nscon*TEL Site*TEl;
title 'PO4 rate';
run;
***(((NO3)))***;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model NO3rate= spec nscon Site TEl spec*nscon 
spec*Site spec*TEl nscon*Site nscon*TEL Site*TEl;
title 'NO3 rate';
run;
***(((Mg)))***;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model MGrate= spec nscon Site TEl spec*nscon spec*Site 
spec*TEl nscon*Site nscon*TEL Site*TEl;
title 'MG rate'; 
run;
***(((K)))****;
proc glm data=allrootuptake;
class spec nscon Site TEl;
Model Krate= spec nscon Site TEl spec*nscon spec*Site 
spec*TEl nscon*Site nscon*TEL Site*TEl;
title 'K rate'; 
run;
******((( Descriptive statistics-by site, species, nscon, TEl***********;
proc sort data=allrootuptake;
by Site spec nscon TEl;
run;
proc means data=allrootuptake;   
by Site;
var NH4delt1 PO4delt1 CAdelt1 Kdelt1 MGdelt1 NH4rate PO4rate CArate Krate MGrate;   
run;   
proc sort data=allrootuptake;   
by spec;   
run;
proc means data=allrootuptake;
by spec;
var NH4delt1 PO4delt1 CAdelt1 Kdelt1 MGdelt1 NH4rate PO4rate CArate Krate MGrate;   
run;  
proc sort data=allrootuptake;  
by TEl;
run;
proc means data=allrootuptake;
by TEl;
var NH4delt1 PO4delt1 CAdelt1 Kdelt1 MGdelt1 NH4rate PO4rate CArate Krate MGrate;   
run;  
proc sort data=allrootuptake;   
by nscon;   
run;
proc means data=allrootuptake;
by nscon;
var NH4delt1 PO4delt1 CAdelt1 Kdelt1 MGdelt1 NH4rate PO4rate CArate Krate MGrate;  
run;
