******************************************************
7/01 Correct the calculation of omfrac, dividing LOI by the sample weight in "Chronos".  The omfrac in Bartlett.txt was already correct.

3/99 Ruth added weighted contents, combined the 80 and 95 data sets, and brought in code from DLS's BARTLT2.SAS to handle the Bartlett stands.

3/99  Analysis for all non-Bartlett stands i.e. "THE CHRONOS 7" compiled by RPP
This program calculates the concentrations (ppm soil and per OM) and contents (g/m2) for 11 elements (Al, Cu, K, Mn, P, Pb, Zn, Mg, Ca, C and N) and pH for 2 years (1979-80 and 1994-95) and two horizons (O and A1).  

The following two data files must be present:
1. 'CHRONOS' (a space delimited file created by rpp from: 'ALL_MASS.DAT', 'NC_MASTR.DAT', and 'CHRONOS7.XCL', which were Dave Szymanski's)
2. 'bartlett.txt' is like "chronos new sheet" but it has C and N.
******************************************************;

OPTIONS LS=78 PS=78 NOCENTER;
DATA Chronos;
INFILE 'Chronos';
INPUT YRCUT site $ LINE YEAR hor $ JUNK MASS LOI SMPLWGT AL_ICP CU_ICP
K_ICP MN_ICP P_ICP PB_ICP ZN_ICP MG_ICP CA_ICP N C;
*****************************************
Calculate organic fraction and elemental concentrations 

Data file CHRONOS contains icp data in ppm in 50 ml of solution.  To convert to ppm soil, multiply by 50 and divide by the sample weight
******************************************************;
omfrac = LOI/SMPLWGT;
AL_PPM=AL_ICP*50/SMPLWGT; CU_PPM=CU_ICP*50/SMPLWGT; K_PPM=K_ICP*50/SMPLWGT; MN_PPM=MN_ICP*50/SMPLWGT; P_PPM=P_ICP*50/SMPLWGT; PB_PPM=PB_ICP*50/SMPLWGT; ZN_PPM=ZN_ICP*50/SMPLWGT; MG_PPM=MG_ICP*50/SMPLWGT; CA_PPM=CA_ICP*50/SMPLWGT;

*****************************************
Calculate content

To convert to content, divide the concentration (ppm) by 10^6 (to convert to g element/g soil) and multyiply by the mass
******************************************************;
AL_CONT=AL_PPM*MASS/1000000; CU_CONT=CU_PPM*MASS/1000000; K_CONT=K_PPM*MASS/1000000; MN_CONT=MN_PPM*MASS/1000000; P_CONT=P_PPM*MASS/1000000; PB_CONT=PB_PPM*MASS/1000000; ZN_CONT=ZN_PPM*MASS/1000000; MG_CONT=MG_PPM*MASS/1000000; CA_CONT=CA_PPM*MASS/1000000; 
N_CONT=N*MASS/100; C_CONT=C*MASS/100;

********************************************
Calculate weighted concentrations

Need to take the sum of the 1995 A1 and O contents to get a single experimental unit (which will be called  FF1995) that can be compared to the 1980 FF data -

Weighted concentrations (sum of the 2 samples' content/sum of the 2 samples' mass) will be used because concentrations are not additive, though contents are -

Separate O and A1 horizons into 2 different data sets (ORG and MIN) -
Rename the content data for each element as (element)CONTO and (element)CONTM -
Then merge the data sets (with the  new content name) and take the sum of the O and A1 -
Units for weighted concentrations are ppm soil  -
********************************************************;

DATA ORG;
SET Chronos;

IF hor = 'O';
MASSO=MASS; Om_massO=omfrac*mass;AL_CONTO=AL_CONT; CU_CONTO=CU_CONT; K_CONTO=K_CONT;
MN_CONTO=MN_CONT; P_CONTO=P_CONT; PB_CONTO=PB_CONT; ZN_CONTO=ZN_CONT; MG_CONTO=MG_CONT; CA_CONTO=CA_CONT; N_CONTO=N_CONT; C_CONTO=C_CONT;
RUN;

DATA MIN;
SET Chronos;

IF hor = 'A1';
MASSM=MASS; Om_massM=omfrac*mass;AL_CONTM=AL_CONT; CU_CONTM=CU_CONT; K_CONTM=K_CONT;
MN_CONTM=MN_CONT; P_CONTM=P_CONT; PB_CONTM=PB_CONT; ZN_CONTM=ZN_CONT; MG_CONTM=MG_CONT; CA_CONTM=CA_CONT; N_CONTM=N_CONT; C_CONTM=C_CONT;

PROC SORT DATA=ORG; BY site LINE; RUN;
PROC SORT DATA=MIN; BY site LINE; RUN;

DATA FF1995;
MERGE ORG MIN;
BY site LINE;

horiz = 'FF';
Mass = MASSO+MASSM;
Om_mass=Om_massO+Om_massM;
AL_CONT=(AL_CONTO+AL_CONTM);
CU_CONT=(CU_CONTO+CU_CONTM);
K_CONT=(K_CONTO+K_CONTM);
MN_CONT=(MN_CONTO+MN_CONTM);
P_CONT=(P_CONTO+P_CONTM);
PB_CONT=(PB_CONTO+PB_CONTM);
ZN_CONT=(ZN_CONTO+ZN_CONTM);
MG_CONT=(MG_CONTO+MG_CONTM);
CA_CONT=(CA_CONTO+CA_CONTM);
N_CONT=(N_CONTO+N_CONTM);
C_CONT=(C_CONTO+C_CONTM);
RUN;

*Now we want the 1980 values back again;
data FF1980;
  set Chronos;
IF hor = 'FF';
Om_mass = mass*omfrac;
N_PPM = N*10000;
C_PPM = C*10000;
*proc print;
run;

/**********************************************************
Here's the Bartlett data.  Read it and calculate derived variables.
Units are g/m2 for mass and contents.  Ca and Mg concentrations are g/kg, the rest are ppm, except for C and N which are %.
Then, READ FOUR TIMES TO GET FOUR DATA SETS, EACH WITH THE
OBSERVATIONS FROM ONE OF THE FOUR HORIZONS (Oi, Oe, Oa, and A1).
Note that the mass of some horizons in some lines was zero.  I didn't have to do anything to handle them until I wanted output by horizon.
Check the means to see that this worked all right.
**********************************************************/

data bartlett;
  infile 'bartlett.txt' firstobs=2;
  input  year yrcut site $ line hor $ mass omfrac Ca_conc Mg_conc P_conc Zn_conc Pb_conc Mn_conc Cu_conc Al_conc K_conc C N; 
  age = year - yrcut; if age = -4 then age = 0;
If mass>0 then do;
  Om_mass= omfrac * mass; Ca_cont=Ca_conc*mass/1000; 
  Mg_cont=Mg_conc*mass/1000; P_cont=P_conc*mass/1000000; 
  Zn_cont=Zn_conc*mass/1000000; Pb_cont=Pb_conc*mass/1000000; 
  Mn_cont=Mn_conc*mass/1000000; Cu_cont=Cu_conc*mass/1000000; 
  Al_cont=Al_conc*mass/1000000; K_cont=K_conc*mass/1000000; 
  N_cont=N*mass/100; C_cont=C*mass/100;
  Ca_ppm=Ca_cont/mass*1000000;
  Ca_Om=Ca_cont/Om_mass; Mg_ppm=Mg_cont/mass*1000000;
  Mg_Om=Mg_cont/Om_mass; P_ppm=P_cont/mass*1000000;
  P_Om=P_cont/Om_mass; Zn_ppm=Zn_cont/mass*1000000;
  Zn_Om=Zn_cont/Om_mass; Pb_ppm=Pb_cont/mass*1000000;
  Pb_Om=Pb_cont/Om_mass; Mn_ppm=Mn_cont/mass*1000000;
  Mn_Om=Mn_cont/Om_mass; Cu_ppm=Cu_cont/mass*1000000;
  Cu_Om=Cu_cont/Om_mass; Al_ppm=Al_cont/mass*1000000;
  Al_Om=Al_cont/Om_mass; K_ppm=K_cont/mass*1000000;
  K_Om=K_cont/Om_mass; N_ppm=N_cont/mass*1000000;
  N_Om=N_cont/Om_mass; C_ppm=C_cont/mass*1000000;
  C_Om=C_cont/Om_mass; CN=C_cont/N_cont;
  NP=N_cont/P_cont; CP=C_cont/P_cont;
end;
if mass=0 then do;
omfrac=.; Ca_ppm=.; Ca_Om=.; Mg_ppm=.; Mg_Om=.; P_ppm=.; P_Om=.; Zn_ppm=.; Zn_Om=.; Pb_ppm=.; Pb_Om=.; Mn_ppm=.; Mn_Om=.;
Cu_ppm=.; Cu_Om=.; Al_ppm=.; Al_Om=.; K_ppm=.; K_Om=.; N_ppm=.; N_Om=.; C_ppm=.; C_Om=.; CN=.; NP=.; CP=.;
/**********************************************************
the following statements are good only if taking logs, otherwise set them to zero; 
CA_CONT=.0001; Mg_CONT=.0001; P_CONT=.0001; Zn_CONT=.0001; Pb_CONT=.0001; Mn_CONT=.0001; Cu_CONT=.0001; Al_CONT=.0001; K_CONT=.0001; N_CONT=.0001; C_CONT=.0001; mass=1; Om_mass=1;
end; 
**********************************************************/
CA_CONT=0; Mg_CONT=0; P_CONT=0; Zn_CONT=0; Pb_CONT=0; Mn_CONT=0; Cu_CONT=0; Al_CONT=0; K_CONT=0; N_CONT=0; C_CONT=0; mass=0; Om_mass=0;
end;

data Oi Oe Oa A1;
  set bartlett;
  if hor in('L') then do;    output Oi;   end;
  if hor in('F') then do;    output Oe;   end;
  if hor in('H') then do;    output Oa;   end;
  if hor in('A1') then do;    output A1;   end;
run;

/**********************************************************
IN EACH OF THESE DATA SETS, THE VARIABLES MUST BE RENAMED SO THAT WHEN THE FOUR ARE MERGED, THE VARIABLES FOR EACH HORIZON ARE DISTINCT.
**********************************************************/

data Oi(drop=omfrac rename=(mass=massOi Om_mass=Om_masOi
        Ca_cont=CacontOi Mg_cont=MgcontOi P_cont=PcontOi
        Zn_cont=ZncontOi Pb_cont=PbcontOi Mn_cont=MncontOi Cu_cont=CucontOi
        Al_cont=AlcontOi K_cont=KcontOi N_cont=NcontOi C_cont=CcontOi));
 set Oi;
run;

data Oe(drop=omfrac rename=(mass=massOe Om_mass=Om_masOe
        Ca_cont=CacontOe Mg_cont=MgcontOe P_cont=PcontOe
        Zn_cont=ZncontOe Pb_cont=PbcontOe Mn_cont=MncontOe Cu_cont=CucontOe
        Al_cont=AlcontOe K_cont=KcontOe N_cont=NcontOe C_cont = CcontOe));
 set Oe;
run;

data Oa(drop=omfrac rename=(mass=massOa Om_mass=Om_masOa
        Ca_cont=CacontOa Mg_cont=MgcontOa P_cont=PcontOa
        Zn_cont=ZncontOa Pb_cont=PbcontOa Mn_cont=MncontOa Cu_cont=CucontOa
        Al_cont=AlcontOa K_cont=KcontOa N_cont=NcontOa C_cont=CcontOa));
 set Oa;
run;

data A1(drop=omfrac rename=(mass=massA1 Om_mass=Om_masA1
        Ca_cont=CacontA1 Mg_cont=MgcontA1 P_cont=PcontA1
        Zn_cont=ZncontA1 Pb_cont=PbcontA1 Mn_cont=MncontA1 Cu_cont=CucontA1
        Al_cont=AlcontA1 K_cont=KcontA1 N_cont=NcontA1 C_cont=CcontA1));
 set A1;
run;

/**********************************************************
SAS DATASETS MUST BE SIMILARLY SORTED BEFORE THEY CAN BE MERGED.
**********************************************************/
proc sort data=Oi; by year site line; run;
proc sort data=Oe; by year site line; run;
proc sort data=Oa; by year site line; run;
proc sort data=A1; by year site line; run;

/**********************************************************
MERGE THE FOUR DATASETS.  EACH OBSERVATION NOW HAS ALL HORIZONS.
**********************************************************/
data bart1;
  merge Oi Oe Oa A1;
  by year site line;

/**********************************************************
CALCULATE SUMS OF MASS AND ELEMENTAL VARIABLES ACROSS HORIZONS, WITHIN LINES.  THE FOLLOWING SUMS INCLUDE THE A1 HORIZON.
(the horizons here are out of order, still)
NOTE THAT THE VARIABLE NAMES ARE THE SAME AS IN Bartlett, WHERE THEY APPLIED TO SAMPLES (BY HORIZON).  THIS COULD BE DANGEROUS BUT IT'S CONVENIENT FOR THE PROC MEANS LATER ON.
**********************************************************/

mass=sum(massA1,massOe,massOa,massOi);
Om_mass=sum(Om_masA1,Om_masOe,Om_masOa,Om_masOi);
Ca_cont=sum(CacontA1,CacontOe,CacontOa,CacontOi);
Mg_cont=sum(MgcontA1,MgcontOe,MgcontOa,MgcontOi);
P_cont=sum(PcontA1,PcontOe,PcontOa,PcontOi);
Zn_cont=sum(ZncontA1,ZncontOe,ZncontOa,ZncontOi);
Pb_cont=sum(PbcontA1,PbcontOe,PbcontOa,PbcontOi);
Mn_cont=sum(MncontA1,MncontOe,MncontOa,MncontOi);
Cu_cont=sum(CucontA1,CucontOe,CucontOa,CucontOi);
Al_cont=sum(AlcontA1,AlcontOe,AlcontOa,AlcontOi);
K_cont=sum(KcontA1,KcontOe,KcontOa,KcontOi);
N_cont=sum(NcontA1,NcontOe,NcontOa,NcontOi);
C_cont=sum(CcontA1,CcontOe,CcontOa,CcontOi);
run; 

data chrono13;
  set FF1995 FF1980 bart1;
  age = year - yrcut; if age = -4 then age = 0; 
  omfrac=Om_mass/mass; Ca_ppm=Ca_cont/mass*1000000;
  Ca_Om=Ca_cont/Om_mass; Mg_ppm=Mg_cont/mass*1000000;
  Mg_Om=Mg_cont/Om_mass; P_ppm=P_cont/mass*1000000;
  P_Om=P_cont/Om_mass; Zn_ppm=Zn_cont/mass*1000000;
  Zn_Om=Zn_cont/Om_mass; Pb_ppm=Pb_cont/mass*1000000;
  Pb_Om=Pb_cont/Om_mass; Mn_ppm=Mn_cont/mass*1000000;
  Mn_Om=Mn_cont/Om_mass; Cu_ppm=Cu_cont/mass*1000000;
  Cu_Om=Cu_cont/Om_mass; Al_ppm=Al_cont/mass*1000000;
  Al_Om=Al_cont/Om_mass; K_ppm=K_cont/mass*1000000;
  K_Om=K_cont/Om_mass; N_ppm=N_cont/mass*1000000;
  N_Om=N_cont/Om_mass; C_ppm=C_cont/mass*1000000;
  C_Om=C_cont/Om_mass; CN=C_cont/N_cont;
  NP=N_cont/P_cont; CP=C_cont/P_cont;


/**********************************************************
MORE DANGEROUS SHORTCUTS: I took logs without changing any variable names, so that the following procedures work either way.  Change the data sets to which they refer (chrono13 for the profile, bartlett for horizons)
**********************************************************/
title "";

data logged13; set bartlett;
MASS=log(MASS); Om_mass=log(Om_mass); omfrac=log(omfrac); 
CA_CONT=log(CA_CONT); Mg_CONT=log(Mg_CONT); P_CONT=log(P_CONT); 
Zn_CONT=log(Zn_CONT); Pb_CONT=log(Pb_CONT); Mn_CONT=log(Mn_CONT); 
Cu_CONT=log(Cu_CONT); Al_CONT=log(Al_CONT); K_CONT=log(K_CONT); 
N_CONT=log(N_CONT); C_CONT=log(C_CONT); Ca_ppm=log(Ca_ppm); 
Ca_Om=log(Ca_Om); Mg_ppm=log(Mg_ppm); Mg_Om=log(Mg_Om); 
P_ppm=log(P_ppm); P_Om=log(P_Om); Zn_ppm=log(Zn_ppm); Zn_Om=log(Zn_Om); 
Pb_ppm=log(Pb_ppm); Pb_Om=log(Pb_Om); Mn_ppm=log(Mn_ppm); 
Mn_Om=log(Mn_Om); Cu_ppm=log(Cu_ppm); Cu_Om=log(Cu_Om); 
Al_ppm=log(Al_ppm); Al_Om=log(Al_Om); K_ppm=log(K_ppm); K_Om=log(K_Om); 
N_ppm=log(N_ppm); N_Om=log(N_Om); C_ppm=log(C_ppm); C_Om=log(C_Om); 
CN=log(CN); NP=log(NP); CP=log(CP);

/**********************************************************
THE FOLLOWING PROCEDURE CALCULATES MEANS AND STANDARD ERRS.  OUTPUT IS WRITTEN TO AN EXTERNAL DATA FILE (AS OPPOSED TO AN INVISIBLE SAS DATA FILE) SO THAT IT CAN BE IMPORTED TO EXCEL FOR GRAPHING.
For horizons, set data=bartlett; by site year hor;
For profile, set data=chrono13; site year;
Add or subtract "hor" from list of outputs to write.
Now we also have data=logged13 (which I use for horizons too!)
**********************************************************/

proc sort data=chrono13;
*proc sort data=bartlett;
*proc sort data=logged13;
*  by site year hor; 
  by site year;

/**********************************************************
MEANS ARE ACROSS LINES WITHIN SITES (N=6 IN 1979, N=5 IN 1984).
**********************************************************/
*proc means data=logged13 noprint;
*proc means data=bartlett n mean stderr;
proc means data=chrono13 n mean stderr;
/*n mean stderr t;*/

  var  age MASS Om_mass omfrac CA_CONT Mg_CONT P_CONT Zn_CONT Pb_CONT Mn_CONT Cu_CONT Al_CONT K_CONT N_CONT C_CONT Ca_ppm  Ca_Om  Mg_ppm  
Mg_Om  P_ppm  P_Om  Zn_ppm  Zn_Om  Pb_ppm  Pb_Om  Mn_ppm  Mn_Om  Cu_ppm  Cu_Om  Al_ppm  Al_Om  K_ppm  K_Om  N_ppm  N_Om  C_ppm  C_Om CN NP CP;
*  by site year hor; 
  by site year;

/**********************************************************
DEFINE THE FILE AND THE NAMES OF THE NEW STATISTICAL OUTPUT VARIABLES THAT WILL BE WRITTEN TO IT.  THE ONLY OUTPUTS AT PRESENT ARE MEAN AND STANDARD ERR.
variable length shortened to 8 
**********************************************************/
  output out=stats
    mean= age MASSmean  OMmean  omfrmean  Camean  Mgmean  Pmean  Znmean  Pbmean  Mnmean  Cumean  Almean  Kmean  Nmean  Cmean  Cappmean  CaOmmean  Mgppmean  
MgOmmean  Pppmean  POmmean  Znppmean  ZnOmmean  Pbppmean  PbOmmean  Mnppmean  MnOmmean  Cuppmean  CuOmmean  Alppmean  AlOmmean  Kppmean  
KOmmean  Nppmean  NOmmean  Cppmean  COmmean  CNmean  NPmean  CPmean  
    stderr = agese  MASSse  OMse  omfrse  Case  Mgse  Pse  Znse  Pbse  Mnse  Cuse  Alse  Kse  Nse  Cse  Ca_ppse  Ca_Omse  Mg_ppse  Mg_Omse  P_ppse  P_Omse  Zn_ppse  Zn_Omse  Pb_ppse  
Pb_Omse  Mn_ppse  Mn_Omse  Cu_ppse  Cu_Omse  Al_ppse  Al_Omse  K_ppse  K_Omse  N_ppse  N_Omse  C_ppse  C_Omse  CNse  NPse  CPse  
;
run;

/**********************************************************
WRITE THE VARIABLES TO THE EXTERNAL DATA FILE
**********************************************************/
data means;
   set stats;
   file 'chron.txt' lrecl=600;
   if _n_=1 then put 'site ' 'year ' 'MASS ' 'se ' 'OMMass ' 'se ' 'omfr ' 'se ' 'C ' 'Cse ' 'N ' 'Nse ' 'P ' 'Pse ' 'C_pp ' 'C_ppse ' 'N_pp ' 'N_ppse ' 'P_pp ' 'P_ppse ' 'C_Om ' 'C_Omse ' 'N_Om ' 'N_Omse ' 'P_Om ' 'P_Omse ' 'CN ' 'CNse ' 'NP ' 'NPse ' 'CP ' 'CPse';
   put site year MASSmean MASSse OMmean Omse omfrmean omfrse Cmean Cse Nmean Nse Pmean Pse Cppmean Cppse Nppmean Nppse Pppmean Pppse COmmean COmse NOmmean NOmse POmmean POmse CNmean CNse NPmean NPse CPmean Cpse;

/********************************************************
T TEST(UNPAIRED):  COMPARING CHANGE WITHIN STANDS (PAIRED T-TESTS OF STANDS ARE DONE WITH PROC UNIVARIATE ON DIFFERENCES, BELOW).
IS THIS NEEDED ? proc sort data=chrono13; by site year; run;
 proc ttest data=chrono13;
   class year;
*var MASS omfrac CA_CONT C_CONT N_CONT P_CONT C_ppm N_ppm P_ppm C_Om N_Om P_Om CN NP CP;
var Zn_CONT Pb_CONT Mn_CONT Cu_CONT Zn_ppm  Zn_Om  Pb_ppm  Pb_Om  Mn_ppm  Mn_Om  Cu_ppm  Cu_Om;
  by site;
run;
*********************************************************/

/********************************************************
TEST FOR SIGNIFICANCE OF LINEAR TRENDS.
*********************************************************/
proc sort data=means; 
*  by hor year;
  by year;
proc glm data=means;
  model MASSmean omfrmean Cmean Nmean Pmean Cppmean Nppmean Pppmean COmmean NOmmean POmmean CNmean NPmean CPmean = age;
*  model Znmean  Pbmean  Mnmean  Cumean Znppmean  ZnOmmean  Pbppmean  PbOmmean  Mnppmean  MnOmmean  Cuppmean  CuOmmean;
*  by hor year;
by year;

/**********************************************************
SEPARATE THE SAMPLING DATES AND COMPUTE DIFFERENCES WITHIN STANDS
**********************************************************/
data chro7980;
  set stats;
  if year < 1981;
mass80=MASSmean; Ommass80=OMmean; Omfrac80=omfrmean; Ca80=Camean; Mg80=Mgmean; P80= Pmean; Zn80=Znmean; Pb80=Pbmean; Mn80=Mnmean; Cu80=Cumean; Al80=Almean; K80= Kmean; N80= Nmean; C80= Cmean; Cappm80=Cappmean; CaOm80=CaOmmean; 
Mgppm80=Mgppmean; MgOm80=MgOmmean; Pppm80=Pppmean; POm80=POmmean; Znppm80=Znppmean; ZnOm80=ZnOmmean; Pbppm80=Pbppmean; PbOm80=PbOmmean; Mnppm80=Mnppmean; MnOm80=MnOmmean; Cuppm80=Cuppmean; CuOm80=CuOmmean; 
Alppm80=Alppmean; AlOm80=AlOmmean; Kppm80=Kppmean; KOm80=KOmmean; Nppm80=Nppmean; NOm80=NOmmean; Cppm80=Cppmean; COm80=COmmean; CN80=CNmean; NP80=NPmean; CP80=CPmean; 

data chro9495;
  set stats;
  if year > 1981;
mass95=MASSmean; Ommass95=OMmean; Omfrac95=omfrmean; Ca95=Camean; Mg95=Mgmean; P95= Pmean; Zn95=Znmean; Pb95=Pbmean; Mn95=Mnmean; Cu95=Cumean; Al95=Almean; K95= Kmean; N95= Nmean; C95= Cmean; Cappm95=Cappmean; CaOm95=CaOmmean; 
Mgppm95=Mgppmean; MgOm95=MgOmmean; Pppm95=Pppmean; POm95=POmmean; Znppm95=Znppmean; ZnOm95=ZnOmmean; Pbppm95=Pbppmean; PbOm95=PbOmmean; Mnppm95=Mnppmean; MnOm95=MnOmmean; Cuppm95=Cuppmean; CuOm95=CuOmmean; 
Alppm95=Alppmean; AlOm95=AlOmmean; Kppm95=Kppmean; KOm95=KOmmean; Nppm95=Nppmean; NOm95=NOmmean; Cppm95=Cppmean; COm95=COmmean; CN95=CNmean; NP95=NPmean; CP95=CPmean; 

proc sort data=chro7980;
  by site;
proc sort data=chro9495;
  by site;
data chrondif;
  merge chro7980 chro9495;
  by site;
massdiff=mass95-mass80; Omdiff=Ommass95-Ommass80; Cadiff=Ca95-Ca80; Mgdiff=Mg95-Mg80; Pdiff=P95-P80; Zndiff=Zn95-Zn80; Pbdiff=Pb95-Pb80; Mndiff=Mn95-Mn80; Cudiff=Cu95-Cu80; Aldiff=Al95-Al80; Kdiff=K95-K80; Ndiff=N95-N80; Cdiff=C95-C80; 
omfrdiff=Omfrac95-Omfrac80; Cappmdif=Cappm95-Cappm80; CaOmdif=CaOm95-COm80; Mgppmdif=Mgppm95-Mgppm80; MgOmdif=MgOm95-MgOm80; Pppmdif=Pppm95-Pppm80; POmdif=POm95-POm80; Znppmdif=Znppm95-Znppm80; ZnOmdif=ZnOm95-ZnOm80; 
Pbppmdif=Pbppm95-Pbppm80; PbOmdif=PbOm95-PbOm80; Mnppmdif=Mnppm95-Mnppm80; MnOmdif=MnOm95-mnOm80; Cuppmdif=Cuppm95-Cuppm80; CuOmdif=CuOm95-CuOm80; Alppmdif=Alppm95-Alppm80; AlOmdif=AlOm95-AlOm80; Kppmdif=Kppm95-Kppm80; 
KOmdif=KOm95-KOm80; Nppmdif=Nppm95-Nppm80; NOmdif=NOm95-NOm80; Cppmdif=Cppm95-Cppm80; COmdif=COm95-COm80; CNdif=CN95-CN80; NPdif=NP95-NP80; CPdif=CP95-CP80;

/**********************************************************
TEST FOR SIGNIFICANCE OF CHANGES
**********************************************************/
*proc sort; 
*  by hor;
proc univariate;
  var MASSdiff omfrdiff Cdiff Ndiff Pdiff Cppmdif Nppmdif Pppmdif COmdif Nomdif POmdif CNdif NPdif CPdif; 
*  var Zndiff Pbdiff Mndiff Cudiff Znppmdif ZnOmdif Pbppmdif PbOmdif Mnppmdif MnOmdif Cuppmdif CuOmdif;
*  by hor;

/**********************************************************
TEST FOR PATTERN OF CHANGES WITH STAND AGE
**********************************************************/
proc glm;
  model MASSdiff omfrdiff Cdiff Ndiff Pdiff Cppmdif Nppmdif Pppmdif COmdif Nomdif POmdif CNdif NPdif CPdif = age;
*  model Zndiff Pbdiff Mndiff Cudiff Znppmdif ZnOmdif Pbppmdif PbOmdif Mnppmdif MnOmdif Cuppmdif CuOmdif = age;
*  by hor;

/********************************************************
WRITE THE DIFFERENCES TO OUTPUT FILES
data difs1;
   set chrondif;
   file 'chrond1.txt';
if _n_=1 then put 'site '  'age ' 'hor ' "massdiff " "Omdiff " "Cadiff " "Mgdiff " "Pdiff " "Zndiff " "Pbdiff " "Mndiff " "Cudiff " "Aldiff " "Kdiff " "Ndiff " "Cdiff ";
   put site age hor massdiff Omdiff Cadiff Mgdiff Pdiff Zndiff Pbdiff Mndiff Cudiff Aldiff Kdiff Ndiff Cdiff;

data difs2;
   set chrondif;
   file 'chrond2.txt';
if _n_=1 then put  'site ' 'age ' 'hor ' "omfrdiff " "Cappmdif " "CaOmdif " "Mgppmdif " "MgOmdif " "Pppmdif " "POmdif " "Znppmdif " "ZnOmdif ";
put site age hor omfrdiff Cappmdif CaOmdif Mgppmdif MgOmdif Pppmdif POmdif Znppmdif ZnOmdif;

data difs3;
   set chrondif;
   file 'chrond3.txt';
if _n_=1 then put  'site ' 'age ' 'hor ' "Pbppmdif " "PbOmdif " "Mnppmdif " "MnOmdif " "Cuppmdif " "CuOmdif " "Alppmdif " "AlOmdif " "Kppmdif ";
put site age hor Pbppmdif PbOmdif Mnppmdif MnOmdif Cuppmdif CuOmdif Alppmdif AlOmdif Kppmdif;

data difs4;
   set chrondif;
   file 'chrond4.txt';
if _n_=1 then put  'site ' 'age ' 'hor ' "KOmdif " "Nppmdif " "NOmdif " "Cppmdif " "COmdif " "CNdif " "NPdif " "CPdif ";
put site age hor KOmdif Nppmdif NOmdif Cppmdif COmdif CNdif NPdif Cpdif;
run;

*********************************************************/
*ENDSAS;

data _null_;
  set chrono13;
  file 'chronos13.txt' lrecl=420;
length comma $1; comma=',';
if _n_=1 then put 'YRCUT'  comma 'site'  comma 'LINE'  comma 'year'  comma
'MASS'  comma 'LOI'  comma 'AL'  comma 'CU'  comma 'K'  comma 'MN'  comma 'P'  comma 'PB'  comma 'ZN'  comma 'MG'  comma 'CA'  comma 'N'  comma 'C'  comma 'AL_PPM'  comma 'CU_PPM'  comma 'K_PPM'  comma 'MN_PPM'  comma 'P_PPM'  comma 'PB_PPM'  comma 'ZN_PPM'  comma 'MG_PPM'  comma 'CA_PPM'  comma 'N_PPM'  comma 'C_PPM';
put YRCUT comma site comma LINE comma year comma MASS comma LOI comma AL_CONT comma CU_CONT comma K_CONT comma MN_CONT comma P_CONT comma PB_CONT comma ZN_CONT comma MG_CONT comma CA_CONT comma N_CONT comma C_CONT comma AL_PPM comma CU_PPM comma K_PPM comma MN_PPM comma P_PPM comma PB_PPM comma ZN_PPM comma MG_PPM comma CA_PPM comma N_PPM comma C_PPM;
run;

