#generate the independent variable
N <- 300
x <- 1:N

#set a seed so that results are reproducible and generate normal noise 
set.seed(9)
noise <- rnorm(N)

#create data with a simple linear trend
y <- .003*x+2

#add noise from a normal distribution with mean = 0 and std = 1
y <- y + noise

#add an additional serial correlation dependent on the noise
y <- y + .5*c(0, noise[1:(length(noise)-1)])

#plot the series and the autocorrelation of y
par(mfrow=c(2,1))
plot(x,y, main = 'y vs x')
acf(y)

#calculate the auto correlation function of y
y_acf <- acf(y,plot=FALSE)

#note that the significant lag is 1
sig_lag <- 1

#remove autocorrelation by subtracting the acf value * y[i-lag] from each y
y <-( y - y_acf$acf[[sig_lag+1]]*c(rep(0,sig_lag),y[1:(length(y)-sig_lag)]))

#plot the series and the autocorrelation of y to examine changes
plot(x,y, main = 'y vs x')
acf(y)

# Calculate Kendall's S statistic
S <- 0
for(i in 1:(N-1)){
    S <- S + sum(sign(y[i]-y[(i+1):N]))
}

# Calculate Variance of Kendall's S
VarS <- (N*(N-1)*(2*N+5))/18

#Determine Z score of S
Z <- S/sqrt(VarS) 

#calculate p-value
p <- 2*(1-pnorm(abs(Z)))

print(p)
# repeat Mann-Kendall test using 'Kendall' package
library('Kendall')
summary(MannKendall(y))









#####Real Data section
x <- read.table('RockyRiver.txt',skip=36)[,5]
y <- read.table('RockyRiver.txt',skip=36)[,6]
N <- length(x)

#plots the series and the autocorrelation of y
par(mfrow=c(2,1))
plot(x,y, main = 'y vs x')
acf(y)

#calculates the auto correlation function of y
y_acf <- acf(y,plot=FALSE)

#note that the most significant lag is 1
sig_lag <- 1

#remove autocorrelation by subtracting the acf value * y[i-lag] from each y
y <-( y - y_acf$acf[[sig_lag+1]]*c(rep(0,sig_lag),y[1:(length(y)-sig_lag)]))

#plots the series and the autocorrelation of y to examine changes
plot(x,y, main = 'y vs x')
acf(y)

# Perform Mann-Kendall test using 'Kendall' package
library('Kendall')
summary(MannKendall(y))







#####Cuyahoga section
x <- read.table('Cuyahoga.txt',skip=36)[,5]
y <- read.table('Cuyahoga.txt',skip=36)[,6]
N <- length(x)

#plots the series and the autocorrelation of y
par(mfrow=c(2,1))
plot(x,y, main = 'y vs x')
acf(y)

#note that there is no significant autocorrelation and, 
#therefore prewhitening is not necessary 

# Perform Mann-Kendall test using 'Kendall' package
library('Kendall')
summary(MannKendall(y))
