use "C:\Users\owner\Desktop\uncertainty_raw_data.dta", clear

program define egsmass

tempname memhold1
postfile `memhold1' i wood bark branch foliage t_above root live_tree using uncertainty, replace
*-These commands swith on and off random numbers for each error component-*
local model_err = 1
local c_err = 0
local sampling_err = 0
local dens_err = 0
local root_err = 0
local air_hollow = 0

forvalues i=1(1)1000 {
preserve
*--Biomass parameters for Jenkins: biomass(kg) = exp(a+blog(dbh)+error)--*
local ald_r = rnormal()*`model_err'
local ald_a = -2.2094
local ald_b = 2.3867 
local ald_e = 0.507441
local bl_r = rnormal()*`model_err' 
local bl_a = -2.5384
local bl_b = 2.4814
local bl_e = 0.182329
local cw_r = rnormal()*`model_err'
local cw_a = -2.0336
local cw_b = 2.2592
local cw_e = 0.294574
local fd_r = rnormal()*`model_err'
local fd_a = -2.2304
local fd_b = 2.4435
local fd_e = 0.218712
local hw_r = rnormal()*`model_err'
local hw_a = -2.5384
local hw_b = 2.4814
local hw_e = 0.182329
local mg_r = rnormal()*`model_err'
local mg_a = -1.9123
local mg_b = 2.3651
local mg_e = 0.491685
local sx_r = rnormal()*`model_err'
local sx_a = -2.0773
local sx_b = 2.3323
local sx_e = 0.250424

*--stem wood ratio of tree components (Jenkins)--*
local aldwd_a = -0.3065
local aldwd_b = -5.424
local blwd_a = -0.3737
local blwd_b = -1.8055
local cwwd_a = -0.3737
local cwwd_b = -1.8055
local fdwd_a = -0.3737
local fdwd_b = -1.8055
local hwwd_a = -0.3737
local hwwd_b = -1.8055
local mgwd_a = -0.3065
local mgwd_b = -5.424
local sxwd_a = -0.3737
local sxwd_b = -1.8055

*Estimate total biomass (Mg) in Jenkins*
gen jtotal_above = exp(`ald_a' + (`ald_b'*log(dbh)) + (`ald_e'*`ald_r'))/1000 if spp == "Alder"
replace jtotal_above = exp(`bl_a' + (`bl_b'*log(dbh)) + (`bl_e'*`bl_r'))/1000 if spp == "Bl"
replace jtotal_above = exp(`cw_a' + (`cw_b'*log(dbh)) + (`cw_e'*`cw_r'))/1000 if spp == "Cw"
replace jtotal_above = exp(`fd_a' + (`fd_b'*log(dbh)) + (`fd_e'*`fd_r'))/1000 if spp == "Fd"
replace jtotal_above = exp(`hw_a' + (`hw_b'*log(dbh)) + (`hw_e'*`hw_r'))/1000 if spp == "Hw" 
replace jtotal_above = exp(`mg_a' + (`mg_b'*log(dbh)) + (`mg_e'*`mg_r'))/1000 if spp == "Mg"
replace jtotal_above = exp(`sx_a' + (`sx_b'*log(dbh)) + (`sx_e'*`sx_r'))/1000 if spp == "Sx"

*stem wood ratio and its mass (Mg)-Jenkins*
gen jstem_wod_ratio = exp(`aldwd_a' + (`aldwd_b'/dbh)) if spp == "Alder"
gen jstem_wood_mass = jstem_wod_ratio*jtotal_above if spp == "Alder"
replace jstem_wod_ratio = exp(`blwd_a' + (`blwd_b'/dbh)) if spp == "Bl"
replace jstem_wood_mass = jstem_wod_ratio*jtotal_above if spp == "Bl" 
replace jstem_wod_ratio = exp(`cwwd_a' + (`cwwd_b'/dbh)) if spp == "Cw"
replace jstem_wood_mass = jstem_wod_ratio*jtotal_above if spp == "Cw"
replace jstem_wod_ratio = exp(`fdwd_a' + (`fdwd_b'/dbh)) if spp == "Fd"
replace jstem_wood_mass = jstem_wod_ratio*jtotal_above if spp == "Fd"
replace jstem_wod_ratio = exp(`hwwd_a' + (`hwwd_b'/dbh)) if spp == "Hw"
replace jstem_wood_mass = jstem_wod_ratio*jtotal_above if spp == "Hw"
replace jstem_wod_ratio = exp(`mgwd_a' + (`mgwd_b'/dbh)) if spp == "Mg"
replace jstem_wood_mass = jstem_wod_ratio*jtotal_above if spp == "Mg"
replace jstem_wod_ratio = exp(`sxwd_a' + (`sxwd_b'/dbh)) if spp == "Sx"
replace jstem_wood_mass = jstem_wod_ratio*jtotal_above if spp == "Sx"

*--Convert wood biomass to volume and volume to sound- and decay-wood volume (m3).  Estimate net stem-wood biomass (Mg)-Jenkins--*
*-species specific sound and decay densities-*
local ald_sound_dens = 0.40
local ald_decay_dens = 0.40
local bl_sound_dens = 0.40
local bl_decay_dens = 0.40
local cw_sound_dens = 0.33 
local cw_decay_dens = 0.1148 /*decay density of cedar*/
local cw_decaydens_e = 0.0369 /*sd of the decay density*/
local cw_decaydens_r = `cw_decay_dens' + rnormal(0,`cw_decaydens_e')*`dens_err'
local fd_sound_dens = 0.43
local fd_decay_dens = 0.43
local hw_sound_dens = 0.43
local hw_decay_dens = 0.22
local mg_sound_dens = 0.46
local mg_decay_dens = 0.46
local sx_sound_dens = 0.38
local sx_decay_dens = 0.38


gen jwood_vol = jstem_wood_mass/`ald_sound_dens' if spp == "Alder"
gen jsound_vol = (1-decay)*jwood_vol if spp == "Alder"
gen jdecay_vol = decay*jwood_vol if spp == "Alder"
gen jsound_mass = jsound_vol*`ald_sound_dens' if spp == "Alder"
gen jdecay_mass = jdecay_vol*`ald_decay_dens' if spp == "Alder"
gen jnet_wood_mass = jsound_mass + jdecay_mass if spp == "Alder"

replace jwood_vol = jstem_wood_mass/`bl_sound_dens' if spp == "Bl"
replace jsound_vol = (1-decay)*jwood_vol if spp == "Bl"
replace jdecay_vol = decay*jwood_vol if spp == "Bl"
replace jsound_mass = jsound_vol*`bl_sound_dens' if spp == "Bl"
replace jdecay_mass = jdecay_vol*`bl_decay_dens' if spp == "Bl"
replace jnet_wood_mass = jsound_mass + jdecay_mass if spp == "Bl"

quietly gen decay_dens_e = `cw_decaydens_r' if spp == "Cw"
replace jwood_vol = jstem_wood_mass/`cw_sound_dens' if spp == "Cw"
replace jsound_vol = (1-decay)*jwood_vol if spp == "Cw"
replace jdecay_vol = decay*jwood_vol*(1-`air_hollow') if spp == "Cw"
replace jsound_mass = jsound_vol*`cw_sound_dens' if spp == "Cw"
replace jdecay_mass = jdecay_vol*decay_dens_e if spp == "Cw"
replace jnet_wood_mass = jsound_mass + jdecay_mass if spp == "Cw"

replace jwood_vol = jstem_wood_mass/`fd_sound_dens' if spp == "Fd"
replace jsound_vol = (1-decay)*jwood_vol if spp == "Fd"
replace jdecay_vol = decay*jwood_vol if spp == "Fd"
replace jsound_mass = jsound_vol*`fd_sound_dens' if spp == "Fd"
replace jdecay_mass = jdecay_vol*`fd_decay_dens' if spp == "Fd"
replace jnet_wood_mass = jsound_mass + jdecay_mass if spp == "Fd"

replace jwood_vol = jstem_wood_mass/`hw_sound_dens' if spp == "Hw"
replace jsound_vol = (1-decay)*jwood_vol if spp == "Hw"
replace jdecay_vol = decay*jwood_vol*(1-`air_hollow') if spp == "Hw"
replace jsound_mass = jsound_vol*`hw_sound_dens' if spp == "Hw"
replace jdecay_mass = jdecay_vol*`hw_decay_dens' if spp == "Hw"
replace jnet_wood_mass = jsound_mass + jdecay_mass if spp == "Hw"

replace jwood_vol = jstem_wood_mass/`mg_sound_dens' if spp == "Mg"
replace jsound_vol = (1-decay)*jwood_vol if spp == "Mg"
replace jdecay_vol = decay*jwood_vol if spp == "Mg"
replace jsound_mass = jsound_vol*`mg_sound_dens' if spp == "Mg"
replace jdecay_mass = jdecay_vol*`mg_decay_dens' if spp == "Mg"
replace jnet_wood_mass = jsound_mass + jdecay_mass if spp == "Mg"

replace jwood_vol = jstem_wood_mass/`sx_sound_dens' if spp == "Sx"
replace jsound_vol = (1-decay)*jwood_vol if spp == "Sx"
replace jdecay_vol = decay*jwood_vol if spp == "Sx"
replace jsound_mass = jsound_vol*`sx_sound_dens' if spp == "Sx"
replace jdecay_mass = jdecay_vol*`sx_decay_dens' if spp == "Sx"
replace jnet_wood_mass = jsound_mass + jdecay_mass if spp == "Sx"

/*program O.K. above*/

*stem bark ratio and its mass (Mg)*
local ald_bark_a = -2.0129
local ald_bark_b = -1.685
local bl_bark_a = -2.098
local bl_bark_b = -1.1432
local cw_bark_a = -2.098
local cw_bark_b = -1.1432
local fd_bark_a = -2.098
local fd_bark_b = -1.1432
local hw_bark_a = -2.098
local hw_bark_b = -1.1432
local mg_bark_a = -2.0129
local mg_bark_b = -1.685
local sx_bark_a = -2.098
local sx_bark_b = -1.1432

gen jstem_bark_ratio = exp(`ald_bark_a' + (`ald_bark_b'/dbh)) if spp == "Alder"
gen jstem_bark_mass = jstem_wod_ratio*jtotal_above if spp == "Alder"
replace jstem_bark_ratio = exp(`bl_bark_a' + (`bl_bark_b'/dbh)) if spp == "Bl"
replace jstem_bark_mass = jstem_bark_ratio*jtotal_above if spp == "Bl"
replace jstem_bark_ratio = exp(`cw_bark_a' + (`cw_bark_b'/dbh)) if spp == "Cw"
replace jstem_bark_mass = jstem_bark_ratio*jtotal_above if spp == "Cw"
replace jstem_bark_ratio = exp(`fd_bark_a' + (`fd_bark_b'/dbh)) if spp == "Fd"
replace jstem_bark_mass = jstem_bark_ratio*jtotal_above if spp == "Fd"
replace jstem_bark_ratio = exp(`hw_bark_a' + (`hw_bark_b'/dbh)) if spp == "Hw"
replace jstem_bark_mass = jstem_bark_ratio*jtotal_above if spp == "Hw"
replace jstem_bark_ratio = exp(`mg_bark_a' + (`mg_bark_b'/dbh)) if spp == "Mg"
replace jstem_bark_mass = jstem_bark_ratio*jtotal_above if spp == "Mg"
replace jstem_bark_ratio = exp(`sx_bark_a' + (`sx_bark_b'/dbh)) if spp == "Sx"
replace jstem_bark_mass = jstem_bark_ratio*jtotal_above if spp == "Sx"

*Foilage ratio and its mass (Mg)*

local ald_foli_a = -4.0813
local ald_foli_b = -5.8816
local bl_foli_a = -2.9584
local bl_foli_b = 4.4766
local cw_foli_a = -2.9584
local cw_foli_b = 4.4766
local fd_foli_a = -2.9584
local fd_foli_b = 4.4766
local hw_foli_a = -2.9584
local hw_foli_b = 4.4766
local mg_foli_a = -4.0813
local mg_foli_b = -5.8816
local sx_foli_a = -2.9584
local sx_foli_b = 4.4766

gen jfoliage_ratio = exp(`ald_foli_a' + (`ald_foli_b'/dbh)) if spp == "Alder"
gen jfoliage_mass = jstem_wod_ratio*jtotal_above if spp == "Alder"
replace jfoliage_ratio = exp(`bl_foli_a' + (`bl_foli_b'/dbh)) if spp == "Bl"
replace jfoliage_mass = jfoliage_ratio*jtotal_above if spp == "Bl"
replace jfoliage_ratio = exp(`cw_foli_a' + (`cw_foli_b'/dbh)) if spp == "Cw"
replace jfoliage_mass = jfoliage_ratio*jtotal_above if spp == "Cw"
replace jfoliage_ratio = exp(`fd_foli_a' + (`fd_foli_b'/dbh)) if spp == "Fd"
replace jfoliage_mass = jfoliage_ratio*jtotal_above if spp == "Fd"
replace jfoliage_ratio = exp(`hw_foli_a' + (`hw_foli_b'/dbh)) if spp == "Hw"
replace jfoliage_mass = jfoliage_ratio*jtotal_above if spp == "Hw"
replace jfoliage_ratio = exp(`mg_foli_a' + (`mg_foli_b'/dbh)) if spp == "Mg"
replace jfoliage_mass = jfoliage_ratio*jtotal_above if spp == "Mg"
replace jfoliage_ratio = exp(`sx_foli_a' + (`sx_foli_b'/dbh)) if spp == "Sx"
replace jfoliage_mass = jfoliage_ratio*jtotal_above if spp == "Sx"

*Branch mass (Mg)
gen jbranch_mass = jtotal_above-(jstem_wood_mass + jstem_bark_mass + jfoliage_mass) if spp == "Alder"
replace jbranch_mass = jtotal_above-(jstem_wood_mass + jstem_bark_mass + jfoliage_mass) if spp == "Bl"
replace jbranch_mass = jtotal_above-(jstem_wood_mass + jstem_bark_mass + jfoliage_mass) if spp == "Cw"
replace jbranch_mass = jtotal_above-(jstem_wood_mass + jstem_bark_mass + jfoliage_mass) if spp == "Fd"
replace jbranch_mass = jtotal_above-(jstem_wood_mass + jstem_bark_mass + jfoliage_mass) if spp == "Hw"
replace jbranch_mass = jtotal_above-(jstem_wood_mass + jstem_bark_mass + jfoliage_mass) if spp == "Mg"
replace jbranch_mass = jtotal_above-(jstem_wood_mass + jstem_bark_mass + jfoliage_mass) if spp == "Sx"

*Net total aboveground(Mg)*
gen jnet_total_above = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass if spp == "Alder"
replace jnet_total_above = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass if spp == "Bl"
replace jnet_total_above = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass if spp == "Cw"
replace jnet_total_above = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass if spp == "Fd"
replace jnet_total_above = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass if spp == "Hw"
replace jnet_total_above = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass if spp == "Mg"
replace jnet_total_above = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass if spp == "Sx"

/*program O.K. above*/

* Total roots mass (Mg)*
local ald_root_a = 1.576 /*root ratio parameter from Li et al. (2003)*/
local ald_root_ae = 0.267 /*root ratio parameter from Li et al. (2003)*/
local ald_root_b = 0.615
local ald_root_be = 0.035
local ald_root_ar = `ald_root_a' + rnormal(0,`ald_root_ae')*`root_err'
local ald_root_br = `ald_root_b' + rnormal(0,`ald_root_be')*`root_err'
local bl_root_a = 0.222
local bl_root_ae = 0.004
local bl_root_ar = `bl_root_a' + rnormal(0,`bl_root_ae')*`root_err'
local cw_root_a = 0.222
local cw_root_ae = 0.004
local cw_root_ar = `cw_root_a' + rnormal(0,`cw_root_ae')*`root_err'
local fd_root_a = 0.222
local fd_root_ae = 0.004
local fd_root_ar = `fd_root_a' + rnormal(0,`fd_root_ae')*`root_err'
local hw_root_a = 0.222
local hw_root_ae = 0.004
local hw_root_ar = `hw_root_a' + rnormal(0,`hw_root_ae')*`root_err'
local mg_root_a = 1.576 /*root ratio parameter from Li et al. (2003)*/
local mg_root_ae = 0.267 /*root ratio parameter from Li et al. (2003)*/
local mg_root_b = 0.615
local mg_root_be = 0.035
local mg_root_ar = `mg_root_a' + rnormal(0,`mg_root_ae')*`root_err'
local mg_root_br = `mg_root_b' + rnormal(0,`mg_root_be')*`root_err'
local sx_root_a = 0.222
local sx_root_ae = 0.004
local sx_root_ar = `sx_root_a' + rnormal(0,`sx_root_ae')*`root_err'


	gen jroot_mass = `ald_root_ar'*(jnet_total_above^`ald_root_br') if spp == "Alder"
	replace jroot_mass = jnet_total_above*`bl_root_ar' if spp == "Bl"
	replace jroot_mass = jnet_total_above*`cw_root_ar' if spp == "Cw"
	replace jroot_mass = jnet_total_above*`fd_root_ar' if spp == "Fd"
	replace jroot_mass = jnet_total_above*`hw_root_ar' if spp == "Hw"
	replace jroot_mass = `mg_root_ar'*(jnet_total_above^`mg_root_br') if spp == "Mg" 
	replace jroot_mass = jnet_total_above*`sx_root_ar' if spp == "Sx"

*program O.k. above*

*whole tree mass (Mg) - Jenkins*
gen jwhole_tree = jnet_total_above + jroot_mass if spp == "Alder"
replace jwhole_tree = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass + jroot_mass if spp == "Bl"
replace jwhole_tree = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass + jroot_mass if spp == "Cw"
replace jwhole_tree = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass + jroot_mass if spp == "Fd"
replace jwhole_tree = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass + jroot_mass if spp == "Hw"
replace jwhole_tree = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass + jroot_mass if spp == "Mg"
replace jwhole_tree = jnet_wood_mass + jstem_bark_mass + jfoliage_mass + jbranch_mass + jroot_mass if spp == "Sx"

*replace all the missing values with zero*
replace jtotal_above = 0 if jtotal_above == .
replace jstem_wod_ratio = 0 if jstem_wod_ratio == .
replace jstem_wood_mass = 0 if jstem_wood_mass == .
replace jwood_vol = 0 if jwood_vol == .
replace jsound_vol = 0 if jsound_vol == .
replace jdecay_vol = 0 if jdecay_vol == .
replace jsound_mass = 0 if jsound_mass == .
replace jdecay_mass = 0 if jdecay_mass == .
replace jnet_wood_mass = 0 if jnet_wood_mass == .
replace jstem_bark_ratio = 0 if jstem_bark_ratio == .
replace jstem_bark_mass = 0 if jstem_bark_mass == .
replace jfoliage_ratio = 0 if jfoliage_ratio == .
replace jfoliage_mass = 0 if jfoliage_mass == .
replace jbranch_mass = 0 if jbranch_mass == .
replace jnet_total_above = 0 if jnet_total_above == .
replace jroot_mass = 0 if jroot_mass == .
replace jwhole_tree = 0 if jwhole_tree == .

*Combined biomass (Mg) between Jenkins*
gen stem_wood_mass = jnet_wood_mass
gen stem_bark_mass = jstem_bark_mass
gen branch_mass = jbranch_mass
gen foliage_mass = jfoliage_mass
gen total_above = jnet_total_above
gen root_mass = jroot_mass
gen total_live_tree = jwhole_tree

*--C concentrations and per ha--*
*-wood-*
local ald_c = 0.477
local ald_e = 0.0012
local ald_wd_e = `ald_c' + rnormal(0,`ald_e')*`c_err'
gen stem_woodc = stem_wood_mass*`ald_wd_e'*perha1 if spp == "Alder"

local bl_c = 0.5008
local bl_e = 0.0045
local bl_wd_e = `bl_c' + rnormal(0,`bl_e')*`c_err'
replace stem_woodc = stem_wood_mass*`bl_wd_e'*perha1 if spp == "Bl"

local cw_c = 0.5154
local cw_e = 0.0038
local cw_wd_e = `cw_c' + rnormal(0,`cw_e')*`c_err'
replace stem_woodc = stem_wood_mass*`cw_wd_e'*perha1 if spp == "Cw"

local fd_c = 0.505
local fd_e = 0.0036
local fd_wd_e = `fd_c' + rnormal(0,`fd_e')*`c_err'
replace stem_woodc = stem_wood_mass*`fd_wd_e'*perha1 if spp == "Fd"

local hw_c = 0.506
local hw_e = 0.0045
local hw_wd_e = `hw_c' + rnormal(0,`hw_e')*`c_err'
replace stem_woodc = stem_wood_mass*`hw_wd_e'*perha1 if spp == "Hw"

local mg_c = 0.4837
local mg_e = 0.0021
local mg_wd_e = `mg_c' + rnormal(0,`mg_e')*`c_err'
replace stem_woodc = stem_wood_mass*`mg_wd_e'*perha1 if spp == "Mg"

local sx_c = 0.5039
local sx_e = 0.0045
local sx_wd_e = `sx_c' + rnormal(0,`sx_e')*`c_err'
replace stem_woodc = stem_wood_mass*`sx_wd_e'*perha1 if spp == "Sx"

*bark*
local ald_c = 0.5
gen stem_barkc = stem_bark_mass*`ald_c'*perha1 if spp == "Alder"
local bl_c = 0.528
replace stem_barkc = stem_bark_mass*`bl_c'*perha1 if spp == "Bl"
local cw_c = 0.53
replace stem_barkc = stem_bark_mass*`cw_c'*perha1 if spp == "Cw"
local fd_c = 0.53
replace stem_barkc = stem_bark_mass*`fd_c'*perha1 if spp == "Fd"
local hw_c = 0.512
replace stem_barkc = stem_bark_mass*`hw_c'*perha1 if spp == "Hw"
local mg_c = 0.4837
replace stem_barkc = stem_bark_mass*`mg_c'*perha1 if spp == "Mg"
local sx_c = 0.5039
replace stem_barkc = stem_bark_mass*`sx_c'*perha1 if spp == "Sx"

*branch*
local ald_c = 0.5
gen branchc = branch_mass*`ald_c'*perha1 if spp == "Alder"
local bl_c = 0.5
replace branchc = branch_mass*`bl_c'*perha1 if spp == "Bl"
local cw_c = 0.5
replace branchc = branch_mass*`cw_c'*perha1 if spp == "Cw"
local fd_c = 0.5
replace branchc = branch_mass*`fd_c'*perha1 if spp == "Fd"
local hw_c = 0.5
replace branchc = branch_mass*`hw_c'*perha1 if spp == "Hw"
local mg_c = 0.5
replace branchc = branch_mass*`mg_c'*perha1 if spp == "Mg"
local sx_c = 0.5
replace branchc = branch_mass*`sx_c'*perha1 if spp == "Sx"

*foliage*
local ald_c = 0.5
gen foliagec = foliage_mass*`ald_c'*perha1 if spp == "Alder"
local bl_c = 0.5
replace foliagec = foliage_mass*`bl_c'*perha1 if spp == "Bl"
local cw_c = 0.5
replace foliagec = foliage_mass*`cw_c'*perha1 if spp == "Cw"
local fd_c = 0.5
replace foliagec = foliage_mass*`fd_c'*perha1 if spp == "Fd"
local hw_c = 0.5
replace foliagec = foliage_mass*`hw_c'*perha1 if spp == "Hw"
local mg_c = 0.5
replace foliagec = foliage_mass*`mg_c'*perha1 if spp == "Mg"
local sx_c = 0.5
replace foliagec = foliage_mass*`sx_c'*perha1 if spp == "Sx"

*total above C*
gen total_abovec = stem_woodc + stem_barkc + branchc + foliagec

*roots*
local ald_c = 0.477
local ald_e = 0.0012
local ald_root_e = `ald_c' + rnormal(0,`ald_e')*`c_err'
gen rootc = root_mass*`ald_root_e'*perha1 if spp == "Alder"

local bl_c = 0.5008
local bl_e = 0.0045
local bl_root_e = `bl_c' + rnormal(0,`bl_e')*`c_err'
replace rootc = root_mass*`bl_root_e'*perha1 if spp == "Bl"

local cw_c = 0.5154
local cw_e = 0.0038
local cw_root_e = `cw_c' + rnormal(0,`cw_e')*`c_err'
replace rootc = root_mass*`cw_root_e'*perha1 if spp == "Cw"

local fd_c = 0.505
local fd_e = 0.0036
local fd_root_e = `fd_c' + rnormal(0,`fd_e')*`c_err'
replace rootc = root_mass*`fd_root_e'*perha1 if spp == "Fd"

local hw_c = 0.506
local hw_e = 0.0045
local hw_root_e = `hw_c' + rnormal(0,`hw_e')*`c_err'
replace rootc = root_mass*`hw_root_e'*perha1 if spp == "Hw"

local mg_c = 0.4837
local mg_e = 0.0021
local mg_root_e = `mg_c' + rnormal(0,`mg_e')*`c_err'
replace rootc = root_mass*`mg_root_e'*perha1 if spp == "Mg"

local sx_c = 0.5039
local sx_e = 0.0045
local sx_root_e = `sx_c' + rnormal(0,`sx_e')*`c_err'
replace rootc = root_mass*`sx_root_e'*perha1 if spp == "Sx"

*total live tree c*
gen total_live_treec = total_abovec + rootc

collapse(sum) stem_woodc stem_barkc branchc foliagec total_abovec rootc total_live_treec, by(starea tu plot)
collapse(mean) meanstem_woodc=stem_woodc meanstem_barkc=stem_barkc meanbranchc=branchc meanfoliagec=foliagec meantotal_abovec=total_abovec meanrootc=rootc meantotal_live_treec=total_live_treec (semean) sestem_woodc=stem_woodc sestem_barkc=stem_barkc sebranchc=branchc sefoliagec=foliagec setotal_abovec=total_abovec serootc=rootc setotal_live_treec=total_live_treec (count) n=total_live_treec, by(starea tu)
egen areatu = group(starea tu)
sort starea

*areatu =1: EGS, areatu =2: EUN, areatu =3: LGR, areatu =4: LGS, areatu =5: LUN*
*areatu =6: MGR, areatu =7: MGS, areatu =8: MUN*
by starea: drop if areatu != 1

local wood = meanstem_woodc + rnormal(0,sestem_woodc)*`sampling_err'
local bark = meanstem_barkc + rnormal(0,sestem_barkc)*`sampling_err'
local branch = meanbranchc + rnormal(0,sebranchc)*`sampling_err'
local foliage = meanfoliagec + rnormal(0,sefoliagec)*`sampling_err'
local t_above = meantotal_abovec + rnormal(0,setotal_abovec)*`sampling_err'
local root = meanrootc + rnormal(0,serootc)*`sampling_err'
local live_tree = meantotal_live_treec + rnormal(0,setotal_live_treec)*`sampling_err'

drop mean* se*

post `memhold1' (`i') (`wood') (`bark') (`branch') (`foliage') (`t_above') (`root') (`live_tree')
restore
}
postclose `memhold1'

end
egsmass
drop _all
program drop _all
quietly use "C:\Users\owner\Documents\uncertainty.dta", clear
gen starea = "East"
gen tu = "GS"
save "C:\Users\owner\Documents\uncertainty.dta", replace
drop _all
